
/**
 ******************************************************************************
 *
 * @file        MG32_USB_Init.h
 * @brief       This file contains all the functions prototypes for the USB initial 
 *              firmware library.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/06/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _MG32_USB_INIT_H
#define _MG32_USB_INIT_H

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"

/* Wizard menu ---------------------------------------------------------------*/
// <<< Use Configuration Wizard in Context Menu >>>

#define MG_USB_SRAM_ADR          0
#define MG_USB_SRAM_TOTAL_SIZE   512

#define MG_USB_EPRX_MSK     0x04
#define MG_USB_EPTX_MSK     0x40
#define MG_USB_DB_SRAM_MSK  0x80
    #define MG_USB_RXTX_DISABLE 0x00
    #define MG_USB_RXTX_EN      0x44
    #define MG_USB_RX_DISABLE   0x00
    #define MG_USB_RX_EN        0x04
    #define MG_USB_RX_DB        0x84
    #define MG_USB_TX_DISABLE   0x00
    #define MG_USB_TX_EN        0x40
    #define MG_USB_TX_DB        0xC0

//================================================================================================================
//Endpoint 0 
//<o0> Endpoint 0 Data Size
#define MG_USB_EP0_DSIZE       64

#define MG_USB_EP0_SRAM_RXSIZE   MG_USB_EP0_DSIZE
#define MG_USB_EP0_SRAM_TXSIZE   MG_USB_EP0_DSIZE

#define MG_USB_EP0_SRAM_SIZE    (MG_USB_EP0_SRAM_RXSIZE + MG_USB_EP0_SRAM_TXSIZE)

//================================================================================================================
//Endpoint 1 
//<e0> Endpoint 1 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP1_EN           1
#define MG_USB_EP1_MDS          0x04
#define MG_USB_EP1RX_DSIZE      64
#define MG_USB_EP1TX_DSIZE      0

#if MG_USB_EP1_EN == 0
    #define MG_USB_EP1_SRAM_RXSIZE  0
    #define MG_USB_EP1_SRAM_TXSIZE  0
    #define MG_USB_EP1_SRAM_SIZE    0
    #define MG_USB_EP1_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP1_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP1_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP1_SRAM_RXSIZE    MG_USB_EP1RX_DSIZE
            #define MG_USB_EP1_SRAM_RXSIZE    MG_USB_EP1RX_DSIZE
            #define MG_USB_EP1_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP1_SRAM_RXSIZE    MG_USB_EP1RX_DSIZE
            #define MG_USB_EP1_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP1_SRAM_RXSIZE    0
        #define MG_USB_EP1_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP1_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP1_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP1_SRAM_RXSIZE    MG_USB_EP1TX_DSIZE
            #define MG_USB_EP1_SRAM_TXSIZE    MG_USB_EP1TX_DSIZE
            #define MG_USB_EP1_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP1_SRAM_TXSIZE    MG_USB_EP1TX_DSIZE
            #define MG_USB_EP1_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP1_SRAM_TXSIZE    0
        #define MG_USB_EP1_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP1_SRAM_SIZE      (MG_USB_EP1_SRAM_RXSIZE + MG_USB_EP1_SRAM_TXSIZE)
    #define MG_USB_EP1_STATUS         (MG_USB_EP1_RXSTATUS | MG_USB_EP1_TXSTATUS)
#endif
//================================================================================================================
//Endpoint 2
//<e0> Endpoint 2 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP2_EN           1
#define MG_USB_EP2_MDS          0x40
#define MG_USB_EP2RX_DSIZE      0
#define MG_USB_EP2TX_DSIZE      64

#if MG_USB_EP2_EN == 0
    #define MG_USB_EP2_SRAM_RXSIZE  0
    #define MG_USB_EP2_SRAM_TXSIZE  0
    #define MG_USB_EP2_SRAM_SIZE    0
    #define MG_USB_EP2_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP2_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP2_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP2_SRAM_RXSIZE    MG_USB_EP2RX_DSIZE
            #define MG_USB_EP2_SRAM_TXSIZE    MG_USB_EP2RX_DSIZE
            #define MG_USB_EP2_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP2_SRAM_RXSIZE    MG_USB_EP2RX_DSIZE
            #define MG_USB_EP2_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP2_SRAM_RXSIZE    0
        #define MG_USB_EP2_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP2_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP2_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP2_SRAM_RXSIZE    MG_USB_EP2TX_DSIZE
            #define MG_USB_EP2_SRAM_TXSIZE    MG_USB_EP2TX_DSIZE
            #define MG_USB_EP2_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP2_SRAM_TXSIZE    MG_USB_EP2TX_DSIZE
            #define MG_USB_EP2_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP2_SRAM_TXSIZE    0
        #define MG_USB_EP2_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP2_SRAM_SIZE      (MG_USB_EP2_SRAM_RXSIZE + MG_USB_EP2_SRAM_TXSIZE)
    #define MG_USB_EP2_STATUS         (MG_USB_EP2_RXSTATUS | MG_USB_EP2_TXSTATUS)
#endif

//================================================================================================================
//Endpoint 3
//<e0> Endpoint 3 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP3_EN           0
#define MG_USB_EP3_MDS          0x44
#define MG_USB_EP3RX_DSIZE      64
#define MG_USB_EP3TX_DSIZE      64

#if MG_USB_EP3_EN == 0
    #define MG_USB_EP3_SRAM_RXSIZE  0
    #define MG_USB_EP3_SRAM_TXSIZE  0
    #define MG_USB_EP3_SRAM_SIZE    0
    #define MG_USB_EP3_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP3_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP3_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP3_SRAM_RXSIZE    MG_USB_EP3RX_DSIZE
            #define MG_USB_EP3_SRAM_TXSIZE    MG_USB_EP3RX_DSIZE
            #define MG_USB_EP3_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP3_SRAM_RXSIZE    MG_USB_EP3RX_DSIZE
            #define MG_USB_EP3_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP3_SRAM_RXSIZE    0
        #define MG_USB_EP3_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP3_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP3_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP3_SRAM_RXSIZE    MG_USB_EP3TX_DSIZE
            #define MG_USB_EP3_SRAM_TXSIZE    MG_USB_EP3TX_DSIZE
            #define MG_USB_EP3_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP3_SRAM_TXSIZE    MG_USB_EP3TX_DSIZE
            #define MG_USB_EP3_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP3_SRAM_TXSIZE    0
        #define MG_USB_EP3_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP3_SRAM_SIZE      (MG_USB_EP3_SRAM_RXSIZE + MG_USB_EP3_SRAM_TXSIZE)
    #define MG_USB_EP3_STATUS         (MG_USB_EP3_RXSTATUS | MG_USB_EP3_TXSTATUS)
#endif
//================================================================================================================
//Endpoint 4
//<e0> Endpoint 4 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP4_EN           0
#define MG_USB_EP4_MDS          0x40
#define MG_USB_EP4RX_DSIZE      64
#define MG_USB_EP4TX_DSIZE      64

#if MG_USB_EP4_EN == 0
    #define MG_USB_EP4_SRAM_RXSIZE  0
    #define MG_USB_EP4_SRAM_TXSIZE  0
    #define MG_USB_EP4_SRAM_SIZE    0
    #define MG_USB_EP4_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP4_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP4_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP4_SRAM_RXSIZE    MG_USB_EP4RX_DSIZE
            #define MG_USB_EP4_SRAM_TXSIZE    MG_USB_EP4RX_DSIZE
            #define MG_USB_EP4_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP4_SRAM_RXSIZE    MG_USB_EP4RX_DSIZE
            #define MG_USB_EP4_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP4_SRAM_RXSIZE    0
        #define MG_USB_EP4_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP4_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP4_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP4_SRAM_RXSIZE    MG_USB_EP4TX_DSIZE
            #define MG_USB_EP4_SRAM_TXSIZE    MG_USB_EP4TX_DSIZE
            #define MG_USB_EP4_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP4_SRAM_TXSIZE    MG_USB_EP4TX_DSIZE
            #define MG_USB_EP4_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP4_SRAM_TXSIZE    0
        #define MG_USB_EP4_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP4_SRAM_SIZE      (MG_USB_EP4_SRAM_RXSIZE + MG_USB_EP4_SRAM_TXSIZE)
    #define MG_USB_EP4_STATUS         (MG_USB_EP4_RXSTATUS | MG_USB_EP4_TXSTATUS)
#endif

//================================================================================================================
//Endpoint 5
//<e0> Endpoint 5 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP5_EN           0
#define MG_USB_EP5_MDS          0x40
#define MG_USB_EP5RX_DSIZE      64
#define MG_USB_EP5TX_DSIZE      64

#if MG_USB_EP5_EN == 0
    #define MG_USB_EP5_SRAM_RXSIZE  0
    #define MG_USB_EP5_SRAM_TXSIZE  0
    #define MG_USB_EP5_SRAM_SIZE    0
    #define MG_USB_EP5_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP5_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP5_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP5_SRAM_RXSIZE    MG_USB_EP5RX_DSIZE
            #define MG_USB_EP5_SRAM_TXSIZE    MG_USB_EP5RX_DSIZE
            #define MG_USB_EP5_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP5_SRAM_RXSIZE    MG_USB_EP5RX_DSIZE
            #define MG_USB_EP5_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP5_SRAM_RXSIZE    0
        #define MG_USB_EP5_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP5_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP5_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP5_SRAM_RXSIZE    MG_USB_EP5TX_DSIZE
            #define MG_USB_EP5_SRAM_TXSIZE    MG_USB_EP5TX_DSIZE
            #define MG_USB_EP5_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP5_SRAM_TXSIZE    MG_USB_EP5TX_DSIZE
            #define MG_USB_EP5_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP5_SRAM_TXSIZE    0
        #define MG_USB_EP5_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP5_SRAM_SIZE      (MG_USB_EP5_SRAM_RXSIZE + MG_USB_EP5_SRAM_TXSIZE)
    #define MG_USB_EP5_STATUS         (MG_USB_EP5_RXSTATUS | MG_USB_EP5_TXSTATUS)
#endif

//================================================================================================================
//Endpoint 6
//<e0> Endpoint 6 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP6_EN           0
#define MG_USB_EP6_MDS          0x40
#define MG_USB_EP6RX_DSIZE      64
#define MG_USB_EP6TX_DSIZE      64

#if MG_USB_EP6_EN == 0
    #define MG_USB_EP6_SRAM_RXSIZE  0
    #define MG_USB_EP6_SRAM_TXSIZE  0
    #define MG_USB_EP6_SRAM_SIZE    0
    #define MG_USB_EP6_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP6_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP6_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP6_SRAM_RXSIZE    MG_USB_EP6RX_DSIZE 
            #define MG_USB_EP6_SRAM_TXSIZE    MG_USB_EP6RX_DSIZE
            #define MG_USB_EP6_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP6_SRAM_RXSIZE    MG_USB_EP6RX_DSIZE
            #define MG_USB_EP6_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP6_SRAM_RXSIZE    0
        #define MG_USB_EP6_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP6_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP6_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP6_SRAM_RXSIZE    MG_USB_EP6TX_DSIZE
            #define MG_USB_EP6_SRAM_TXSIZE    MG_USB_EP6TX_DSIZE
            #define MG_USB_EP6_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP6_SRAM_TXSIZE    MG_USB_EP6TX_DSIZE
            #define MG_USB_EP6_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP6_SRAM_TXSIZE    0
        #define MG_USB_EP6_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP6_SRAM_SIZE      (MG_USB_EP6_SRAM_RXSIZE + MG_USB_EP6_SRAM_TXSIZE)
    #define MG_USB_EP1_STATUS         (MG_USB_EP6_RXSTATUS | MG_USB_EP6_TXSTATUS)
#endif

//================================================================================================================
//Endpoint 7
//<e0> Endpoint 7 Enable
    //<o1> Endpoint Mode is <0x04=> RX Normal Mode  <0x40=> TX Normal Mode <0x44=> TX & RX Normal Mode    
    //                      <0x84=> RX Double Buffer mode <0xC0=> TX Double Buffer Mode
    //<o2> Endpoint Data RX Size (0-512) byte <0-512>
    //<o3> Endpoint Data TX Size (0-512) byte <0-512>
//</e>
#define MG_USB_EP7_EN           1
#define MG_USB_EP7_MDS          0x40
#define MG_USB_EP7RX_DSIZE      0
#define MG_USB_EP7TX_DSIZE      2

#if MG_USB_EP7_EN == 0
    #define MG_USB_EP7_SRAM_RXSIZE  0
    #define MG_USB_EP7_SRAM_TXSIZE  0
    #define MG_USB_EP7_SRAM_SIZE    0
    #define MG_USB_EP7_STATUS       MG_USB_RXTX_DISABLE
#else
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP7_MDS & MG_USB_EPRX_MSK) == MG_USB_EPRX_MSK)
        #if((MG_USB_EP7_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP7_SRAM_RXSIZE    MG_USB_EP7RX_DSIZE
            #define MG_USB_EP7_SRAM_TXSIZE    MG_USB_EP7RX_DSIZE
            #define MG_USB_EP7_RXSTATUS       MG_USB_RX_DB
        #else
            #define MG_USB_EP7_SRAM_RXSIZE    MG_USB_EP7RX_DSIZE
            #define MG_USB_EP7_RXSTATUS       MG_USB_RX_EN
        #endif
    #else
        #define MG_USB_EP7_SRAM_RXSIZE    0
        #define MG_USB_EP7_RXSTATUS       MG_USB_RX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #if((MG_USB_EP7_MDS & MG_USB_EPTX_MSK) == MG_USB_EPTX_MSK)
        #if((MG_USB_EP7_MDS & MG_USB_DB_SRAM_MSK) == MG_USB_DB_SRAM_MSK)
            #define MG_USB_EP7_SRAM_RXSIZE    MG_USB_EP7TX_DSIZE
            #define MG_USB_EP7_SRAM_TXSIZE    MG_USB_EP7TX_DSIZE
            #define MG_USB_EP7_TXSTATUS       MG_USB_TX_DB
        #else
            #define MG_USB_EP7_SRAM_TXSIZE    MG_USB_EP7TX_DSIZE
            #define MG_USB_EP7_TXSTATUS       MG_USB_TX_EN
        #endif
    #else
        #define MG_USB_EP7_SRAM_TXSIZE    0
        #define MG_USB_EP7_TXSTATUS       MG_USB_TX_DISABLE
    #endif
    //-----------------------------------------------------------------------------------------------
    #define MG_USB_EP7_SRAM_SIZE      (MG_USB_EP7_SRAM_RXSIZE + MG_USB_EP7_SRAM_TXSIZE)
    #define MG_USB_EP7_STATUS         (MG_USB_EP7_RXSTATUS | MG_USB_EP7_TXSTATUS)
#endif

//================================================================================================================
//USB SRAM USE STATUS
#define MG_USB_SRAM_USBTOTAL_SIZE   (MG_USB_EP0_SRAM_SIZE + MG_USB_EP1_SRAM_SIZE + MG_USB_EP2_SRAM_SIZE + MG_USB_EP3_SRAM_SIZE + MG_USB_EP4_SRAM_SIZE + MG_USB_EP5_SRAM_SIZE + MG_USB_EP6_SRAM_SIZE + MG_USB_EP7_SRAM_SIZE) 

#if MG_USB_SRAM_USBTOTAL_SIZE > MG_USB_SRAM_TOTAL_SIZE
    #error MG32_USB_Init.h total use usb sram size over.
#endif

#define USB_EP0_SRAM_RXADR   MG_USB_SRAM_ADR    
#define USB_EP0_SRAM_TXADR   (USB_EP0_SRAM_RXADR +  MG_USB_EP0_SRAM_RXSIZE)

#define USB_EP1_SRAM_RXADR   (USB_EP0_SRAM_TXADR + MG_USB_EP0_SRAM_TXSIZE)
#define USB_EP1_SRAM_TXADR   (USB_EP1_SRAM_RXADR + MG_USB_EP1_SRAM_TXSIZE)

#define USB_EP2_SRAM_RXADR   (USB_EP1_SRAM_TXADR + MG_USB_EP1_SRAM_TXSIZE)
#define USB_EP2_SRAM_TXADR   (USB_EP2_SRAM_RXADR + MG_USB_EP2_SRAM_TXSIZE)

#define USB_EP3_SRAM_RXADR   (USB_EP2_SRAM_TXADR + MG_USB_EP2_SRAM_TXSIZE)
#define USB_EP3_SRAM_TXADR   (USB_EP3_SRAM_RXADR + MG_USB_EP3_SRAM_TXSIZE)

#define USB_EP4_SRAM_RXADR   (USB_EP3_SRAM_TXADR + MG_USB_EP3_SRAM_TXSIZE)
#define USB_EP4_SRAM_TXADR   (USB_EP4_SRAM_RXADR + MG_USB_EP4_SRAM_TXSIZE)

#define USB_EP5_SRAM_RXADR   (USB_EP4_SRAM_TXADR + MG_USB_EP4_SRAM_TXSIZE)
#define USB_EP5_SRAM_TXADR   (USB_EP5_SRAM_RXADR + MG_USB_EP5_SRAM_TXSIZE)

#define USB_EP6_SRAM_RXADR   (USB_EP5_SRAM_TXADR + MG_USB_EP5_SRAM_TXSIZE)
#define USB_EP6_SRAM_TXADR   (USB_EP6_SRAM_RXADR + MG_USB_EP6_SRAM_TXSIZE)

#define USB_EP7_SRAM_RXADR   (USB_EP6_SRAM_TXADR + MG_USB_EP6_SRAM_TXSIZE)
#define USB_EP7_SRAM_TXADR   (USB_EP7_SRAM_RXADR + MG_USB_EP7_SRAM_TXSIZE)

//================================================================================================================
//LPM Control.
//<e0> Enable LPM

//</e>
#define MG_USB_LPM_EN      0


// <<< end of Configuration section >>> 

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


#endif


